/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.IntegerType;
import com.sun.jna.JNIEnv;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.MethodResultContext;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.Version;
import com.sun.jna.WString;
import com.sun.jna.WeakMemoryHolder;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import melotr.ConfigChangedHandler;
import melotr.MCDAClientWindowHelper;
import melotr.MCDAEventListener;
import melotr.MCDARichHelper;

public final class Native
implements Version {
    private static final int CVT_STRUCTURE = 3;
    private static final int CVT_ARRAY_LONG = 10;
    private static final int CVT_ARRAY_BYTE = 6;
    static final int MAX_PADDING;
    public static final int POINTER_SIZE;
    public static final Charset DEFAULT_CHARSET;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static final int CVT_TYPE_MAPPER_WSTRING = 25;
    private static final int CVT_WSTRING = 20;
    static final String JNA_TMPLIB_PREFIX;
    private static final Map<Class<?>, long[]> registeredClasses;
    public static final boolean DEBUG_LOAD;
    private static final int CVT_TYPE_MAPPER = 23;
    static final int MAX_ALIGNMENT;
    private static final int CVT_ARRAY_DOUBLE = 12;
    private static final Map<Class<?>, NativeLibrary> registeredLibraries;
    private static final ThreadLocal<Memory> nativeThreadTerminationFlag;
    private static final int CVT_BUFFER = 5;
    private static final int CVT_ARRAY_CHAR = 8;
    private static final int TYPE_WCHAR_T = 2;
    public static final int SIZE_T_SIZE;
    public static final String DEFAULT_ENCODING;
    private static final Object finalizer;
    public static final boolean DEBUG_JNA_LOAD;
    private static final int CVT_STRUCTURE_BYVAL = 4;
    private static final Map<Thread, Pointer> nativeThreads;
    private static final int CVT_ARRAY_SHORT = 7;
    private static final Map<Class<?>, Reference<?>> libraries;
    private static final int CVT_ARRAY_FLOAT = 11;
    static String jnidispatchPath;
    private static final int CVT_INTEGER_TYPE = 21;
    private static final Logger LOG;
    private static final int CVT_ARRAY_INT = 9;
    private static final Map<Class<?>, Map<String, Object>> typeOptions;
    private static final int TYPE_LONG_DOUBLE = 5;
    public static final int LONG_DOUBLE_SIZE;
    private static final int CVT_SHORT = 28;
    private static final int CVT_STRING = 2;
    private static final int CVT_DEFAULT = 0;
    private static final int CVT_BYTE = 29;
    private static final int CVT_FLOAT = 16;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    private static final String _OPTION_ENCLOSING_LIBRARY;
    private static final int TYPE_SIZE_T = 3;
    private static final int CVT_CALLBACK = 15;
    private static final int CVT_UNSUPPORTED = -1;
    private static final int TYPE_LONG = 1;
    private static final int CVT_POINTER = 1;
    public static final int BOOL_SIZE;
    private static final int CVT_BOOLEAN = 14;
    private static final int CVT_NATIVE_MAPPED = 17;
    private static final int CVT_OBJECT = 26;
    private static final int CVT_JNIENV = 27;
    private static final int CVT_ARRAY_BOOLEAN = 13;
    private static final Level DEBUG_JNA_LOAD_LEVEL;
    private static final int CVT_POINTER_TYPE = 22;
    private static final int TYPE_VOIDP = 0;
    private static final int CVT_TYPE_MAPPER_STRING = 24;
    private static final int TYPE_BOOL = 4;
    static final int CB_OPTION_IN_DLL = 2;
    public static final int LONG_SIZE;
    static final int CB_HAS_INITIALIZER = 1;
    private static final int CVT_NATIVE_MAPPED_STRING = 18;
    public static final int WCHAR_SIZE;
    static final int CB_OPTION_DIRECT = 1;
    private static final int CVT_NATIVE_MAPPED_WSTRING = 19;

    private static native /* synthetic */ void invokeStructure(Function var0, long var1, int var3, Object[] var4, long var5, long var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void unregisterAll() {
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            for (Map.Entry<Class<?>, long[]> e : registeredClasses.entrySet()) {
                Native.unregister(e.getKey(), e.getValue());
            }
            registeredClasses.clear();
        }
    }

    private /* synthetic */ Native() {
    }

    public static int getStructureAlignment(Class<?> cls) {
        Integer alignment = (Integer)Native.getLibraryOptions(cls).get(FunctionResultContext$CallbackResultContext.p("\u3df3\u56d7\u4b5e\uaf18\u1026\uda8f\uadf3\ub5d1\u7253\udbba\uf799\ua768\uc2b8\u24d7\u6e90\u9451\ufdac\uc97e\u136a"));
        return alignment == null ? 0 : alignment;
    }

    static void removeTemporaryFiles() throws IOException {
        File dir = Native.getTempDir();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(MCDARichHelper.l(Klass$JNIEnv.n("\uf702\u6eab"))) && name.startsWith(Klass$JNIEnv.n("\uf75c\u6ed4\uabf4"));
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; files != null && i < files.length; ++i) {
            File marker = files[i];
            String name = marker.getName();
            name = name.substring(0, name.length() - 2);
            File target = new File(marker.getParentFile(), name);
            if (target.exists() && !target.delete()) continue;
            marker.delete();
        }
    }

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    static native char getChar(Pointer var0, long var1, long var3);

    static native void read(Pointer var0, long var1, long var3, double[] var5, int var6, int var7);

    static boolean isUnpacked(File file) {
        return file.getName().startsWith(Union$PointerType.H("\u4eb6\u1ff8\u32d3"));
    }

    private static native /* synthetic */ long _getDirectBufferPointer(Buffer var0);

    static boolean isCompatibleVersion(String expectedVersion, String nativeVersion) {
        String[] expectedVersionParts = expectedVersion.split(ConfigChangedHandler.l(Union$PointerType.H("\uf571\ucba1")));
        String[] nativeVersionParts = nativeVersion.split(MCDARichHelper.l(Union$PointerType.H("\uf505\ucbca")));
        if (expectedVersionParts.length < 3 || nativeVersionParts.length < 3) {
            return false;
        }
        int expectedMajor = Integer.parseInt(expectedVersionParts[0]);
        int nativeMajor = Integer.parseInt(nativeVersionParts[0]);
        int expectedMinor = Integer.parseInt(expectedVersionParts[1]);
        int nativeMinor = Integer.parseInt(nativeVersionParts[1]);
        if (expectedMajor != nativeMajor) {
            return false;
        }
        return expectedMinor <= nativeMinor;
    }

    static Class<?> findEnclosingLibraryClass(Class<?> cls) {
        Class<?> declaring;
        Class<?> fromDeclaring;
        if (cls == null) {
            return null;
        }
        Map<String, Object> libOptions = typeOptions.get(cls);
        if (libOptions != null) {
            Class enclosingClass = (Class)libOptions.get(Union$CallbackResultContext.U("\uf168\uee8e\uae69\u3fdb\u31e2\uf545\u6941\u0b5a\u7579\ub1ac\ued2d\u09db\u8768\uce31\uea65\ubbef\u666e"));
            if (enclosingClass != null) {
                return enclosingClass;
            }
            return cls;
        }
        if (Library.class.isAssignableFrom(cls)) {
            return cls;
        }
        if (Callback.class.isAssignableFrom(cls)) {
            cls = CallbackReference.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(declaring = cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    static native void read(Pointer var0, long var1, long var3, float[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, char[] var5, int var6, int var7);

    static native ByteBuffer getDirectByteBuffer(Pointer var0, long var1, long var3, long var5);

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    private static native /* synthetic */ void setDetachState(boolean var0, long var1);

    public static native void ffi_free_closure(long var0);

    private static native /* synthetic */ int sizeof(int var0);

    public static Pointer getDirectBufferPointer(Buffer b) {
        long peer = Native._getDirectBufferPointer(b);
        return peer == 0L ? null : new Pointer(peer);
    }

    public static native int getLastError();

    public static byte[] toByteArray(String s) {
        return Native.toByteArray(s, Native.getDefaultStringEncoding());
    }

    static Structure invokeStructure(Function function, long fp, int callFlags, Object[] args, Structure s) {
        Native.invokeStructure(function, fp, callFlags, args, s.getPointer().peer, s.getTypeInfo().peer);
        return s;
    }

    private static /* synthetic */ void loadLibraryInstance(Class<?> cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u11f0\u5b76\ud2ac\ude28\u187f\u63e4\uaf26\u4206\ub18b\u8328\u2dba\u5340\u9843\u6f48\u8feb\uc9ba\u1acc\u3162\uc451\u0652\u93c6\u7afb\uf1a0\u31ed\u1925\u1909\u7c60\u629c\u6d62")) + cls + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u118b\u5b36")) + e + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u119a")));
            }
        }
    }

    private static /* synthetic */ void loadNativeDispatchLibrary() {
        String jnaNosys;
        if (!Boolean.getBoolean(MCDARichHelper.l(Union$CallbackResultContext.U("\u938b\u617a\uf351\u8e8c\u5d2d\ud52a\u0625\u7e31\u7f82\u1665\ub469\ua26d")))) {
            try {
                Native.removeTemporaryFiles();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93b3\u615d\uf369\u8e85\u5d0c\ud523\u063a\u7e36\u7f83\u166d\ub475\ua23b\ub0c4\u51ff\u7a19\u4797\ub829\u9571\u2bc3\ue56f\uf7df\ud09b\u9702\u9789\u5abf\ua8e5\u2e34\uaf7e\u3587\ue8ca\u9cd3\u5d5a\u4eab\uc799\u6f52\ub4d8\u6055\u38dd\u0b61\u1a49\u5ed7\u46ca\ued1b\u6852\u3a62\u29d8\ud138\u1135\u776b")), e);
            }
        }
        String libName = System.getProperty(MCDARichHelper.l(Union$CallbackResultContext.U("\u93f8\u6109\uf322\u8eff\u5d52\ud559\u064c\u7e58\u7faf\u161b\ub410\ua217\ub0fd\u51a3\u7a4f\u47df\ub814\u9508\u2bac\ue506\uf7a5")), ConfigChangedHandler.l(Union$CallbackResultContext.U("\u9393\u617d\uf341\u8ec1\u5d32\ud531\u0638\u7e39\u7f9e\u1660\ub47a")));
        String bootPath = System.getProperty(MCDARichHelper.l(Union$CallbackResultContext.U("\u93f8\u6109\uf322\u8eff\u5d52\ud559\u064c\u7e58\u7faf\u161b\ub410\ua217\ub0fd\u51a3\u7a4f\u47df\ub814\u9516\u2bac\ue51f\uf7a8")));
        if (bootPath != null) {
            StringTokenizer dirs = new StringTokenizer(bootPath, File.pathSeparator);
            while (dirs.hasMoreTokens()) {
                String ext;
                String orig;
                String dir = dirs.nextToken();
                File file = new File(new File(dir), System.mapLibraryName(libName).replace(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93bb\u611b\uf33d\u8ea5\u5d5e\ud54c")), MCDARichHelper.l(Union$CallbackResultContext.U("\u93bc\u610d\uf32d\u8eb8\u5d5c\ud55f\u0641"))));
                String path = file.getAbsolutePath();
                LOG.log(DEBUG_JNA_LOAD_LEVEL, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93d9\u6110\uf32b\u8ea2\u5d5e\ud540\u0643\u7e14\u7fef\u1601\ub45e\ua216\ub0b8\u51a7")), path);
                if (file.exists()) {
                    try {
                        LOG.log(DEBUG_JNA_LOAD_LEVEL, MCDARichHelper.l(Union$CallbackResultContext.U("\u93b5\u6166\uf349\u8ecb\u5d2d\ud522\u0670\u7e24\u7fc2\u1679")), path);
                        System.setProperty(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93ff\u6111\uf32d\u8ead\u5d5e\ud55d\u0654\u7e55\u7ff2\u160c\ub416\ua243\ub0f8\u51bb\u7a4e\u47d6")), path);
                        System.load(path);
                        jnidispatchPath = path;
                        LOG.log(DEBUG_JNA_LOAD_LEVEL, MCDARichHelper.l(Union$CallbackResultContext.U("\u93a7\u617b\uf345\u8ecc\u5d27\ud565\u063a\u7e31\u7f9b\u1660\ub463\ua275\ub08c\u51d0\u7a3a\u47b6\ub821\u9535\u2bdf\ue56c\uf793\ud08e\u9745\u979d")), path);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
                if (!Platform.isMac()) continue;
                if (path.endsWith(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u939d\u616a\uf344\u8ecc\u5d39")))) {
                    orig = MCDARichHelper.l(Union$CallbackResultContext.U("\u93f6\u611e\uf32f\u8eb8\u5d52"));
                    ext = ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93ff\u6111\uf32d\u8ea5\u5d5e\ud54c"));
                } else {
                    orig = MCDARichHelper.l(Union$CallbackResultContext.U("\u938b\u617a\uf359\u8ece\u5d2a\ud527"));
                    ext = ConfigChangedHandler.l(Union$CallbackResultContext.U("\u939d\u616a\uf344\u8ecc\u5d39"));
                }
                path = path.substring(0, path.lastIndexOf(orig)) + ext;
                LOG.log(DEBUG_JNA_LOAD_LEVEL, MCDARichHelper.l(Union$CallbackResultContext.U("\u93ad\u617b\uf35f\u8ec9\u5d2a\ud52b\u0637\u7e7f\u7f9b\u166a\ub42a\ua27d\ub0cc\u51cc")), path);
                if (!new File(path).exists()) continue;
                try {
                    LOG.log(DEBUG_JNA_LOAD_LEVEL, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93c1\u610d\uf33d\u8ea0\u5d59\ud549\u0604\u7e4f\u7fb6\u1612")), path);
                    System.setProperty(MCDARichHelper.l(Union$CallbackResultContext.U("\u938b\u617a\uf359\u8ec6\u5d2a\ud536\u0620\u7e3e\u7f86\u1667\ub462\ua228\ub08c\u51d0\u7a3a\u47bd")), path);
                    System.load(path);
                    jnidispatchPath = path;
                    LOG.log(DEBUG_JNA_LOAD_LEVEL, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93d3\u6110\uf331\u8ea7\u5d53\ud50e\u064e\u7e5a\u7fef\u160b\ub417\ua21e\ub0f8\u51bb\u7a4e\u47dd\ub855\u955e\u2bab\ue507\uf7e7\ud0e5\u9731\u97f6")), path);
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    LOG.log(Level.WARNING, MCDARichHelper.l(Union$CallbackResultContext.U("\u93a7\u617d\uf35c\u8ec7\u5d63\ud523\u063f\u7e2a\u7f9c\u1660\ub42a\ua267\ub088\u5191")) + path + ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93d9\u6171\uf35d\u8ed1\u5d7b\ud52c\u0627\u7e2c\u7fca\u166f\ub47d\ua260\ub080\u51d7\u7a34\u47be\ub834\u9528\u2b86")) + ex.getMessage(), ex);
                }
            }
        }
        if (!Boolean.parseBoolean(jnaNosys = System.getProperty(MCDARichHelper.l(Union$CallbackResultContext.U("\u93f8\u6109\uf322\u8eff\u5d5e\ud559\u0650\u7e55\u7ff2")), ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93e1\u610d\uf331\u8eac")))) || Platform.isAndroid()) {
            try {
                LOG.log(DEBUG_JNA_LOAD_LEVEL, MCDARichHelper.l(Union$CallbackResultContext.U("\u93b5\u6166\uf349\u8ecb\u5d2d\ud522\u0670\u7e77\u7f84\u166d\ub46b\ua226\ub090\u51de\u7a2f\u47b1\ub805\u957c\u2bdc\ue56a\uf7d2\ud087\u970c\u97c9\u5aa7\ua8eb\u2e79\uaf69")), libName);
                System.loadLibrary(libName);
                LOG.log(DEBUG_JNA_LOAD_LEVEL, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93d3\u6110\uf331\u8ea7\u5d53\ud50e\u064e\u7e5a\u7fef\u160b\ub417\ua21e\ub0f8\u51bb\u7a4e\u47dd\ub855\u955e\u2ba5\ue51d\uf7e7\ud0ed\u9778\u97f8\u5a87\ua89e\u2e50\uaf5f\u35f4\ue8b1\u9ca2\u5d30")));
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (Boolean.getBoolean(MCDARichHelper.l(Union$CallbackResultContext.U("\u93f8\u6109\uf322\u8eff\u5d5e\ud559\u0640\u7e40\u7fe0\u1604\ub40a\ua205\ub0ee\u51b6\u7a55")))) {
            throw new UnsatisfiedLinkError(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u93ac\u617d\uf349\u8ec7\u5d37\ud527\u0668\u7e2c\u7f85\u1623\ub47e\ua26e\ub087\u51d7\u7a22\u47b7\ub871\u9558\u2be8\ue55e\uf78b\ud09c\u970c\u9793\u5af6\ua8e1\u2e34\uaf33\u359b\ue8c9\u9cca\u5d44\u4ea3\uc7cb\u6f52\ub49d\u6054\u38c4\u0b6c\u1a49\u5ed7\u46ca\ued1b")));
        }
        Native.loadNativeDispatchLibraryFromClasspath();
    }

    public static native void setLastError(int var0);

    static native long indexOf(Pointer var0, long var1, long var3, byte var5);

    static Class<?> findDirectMappedClass(Class<?> cls) {
        Method[] methods;
        for (Method m : methods = cls.getDeclaredMethods()) {
            if ((m.getModifiers() & 0x100) == 0) continue;
            return cls;
        }
        int idx = cls.getName().lastIndexOf(MCDARichHelper.l(Klass$JNIEnv.n("\u8ee1")));
        if (idx != -1) {
            String name = cls.getName().substring(0, idx);
            try {
                return Native.findDirectMappedClass(Class.forName(name, true, cls.getClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(ConfigChangedHandler.l(Klass$JNIEnv.n("\u8e81\u453c\u0d31\u725e\udbc3\uc846\ub30c\u2859\uefb2\ue6f4\u8ad5\ua8f5\u2ccd\u28b1\ub4aa\u0e2e\u88c2\u9c4d\ue029\u43d4\u55fa\u58fc\u0535\u6663\u5293\u6339\u17dc\u9773\ubdc9\u0118\u28df\ud44b\uc77c\ub56c\u09a1\ucf65\u8ae0\u53de\u1288\ubad2\u4b2e\u2ef0\uc096\uadf6\uedaa\uf221\u3bbc\u5cd8\u17eb\uf75e\u8aee\u4811\u6cf0\uadc0\u64d1\u8420\u1474\ufb04\ua53b\u61e5\u2a1e\u641c\ua928\u471e\uda35\u4db5\ud742\u8b9d")) + cls + MCDARichHelper.l(Klass$JNIEnv.n("\u8eec")));
    }

    static File getTempDir() throws IOException {
        File jnatmp;
        String prop = System.getProperty(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u08d4\u950b\u3065\u2c28\u1356\u56dd\u1ebb\u7c0c\ue91f\u55ba")));
        if (prop != null) {
            jnatmp = new File(prop);
            jnatmp.mkdirs();
        } else {
            File tmp = new File(System.getProperty(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u08a0\u956f\u3006\u2c0c\u1378\u56b2\u1ed0\u7c2d\ue976\u55ce\u0d1b\ua26a\ua966\ua317"))));
            if (Platform.isMac()) {
                jnatmp = new File(System.getProperty(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u08a7\u957a\u300d\u2c18\u1360\u56b4\u1ec8\u7c69\ue97f"))), MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u08f5\u9514\u3061\u2c6c\u1344\u56da\u1eb5\u7c5f\ue932\u55b1\u0d7b\ua215\ua919\ua365\u70b9\ud178\ub85a\u1d85\u771f\uf624\u4545\ucb3f\uca62")));
            } else if (Platform.isLinux() || Platform.isSolaris() || Platform.isAIX() || Platform.isFreeBSD() || Platform.isNetBSD() || Platform.isOpenBSD() || Platform.iskFreeBSD()) {
                String xdgCacheEnvironment = System.getenv(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u08e6\u9521\u3043\u2c59\u1361\u56f1\u1e88\u7c20\ue933\u5597\u0d57\ua22a\ua936\ua34b")));
                File xdgCacheFile = xdgCacheEnvironment == null || xdgCacheEnvironment.trim().isEmpty() ? new File(System.getProperty(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u08cc\u950e\u3066\u2c6c\u130b\u56c0\u1ea3\u7c1d\ue914"))), ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u0890\u9506\u3065\u2c65\u134a\u56d5"))) : new File(xdgCacheEnvironment);
                jnatmp = new File(xdgCacheFile, MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u0880\u9540\u3031\u2c42\u1322\u56be\u1ed2\u7c73")));
            } else {
                jnatmp = new File(tmp, ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u08d4\u950b\u3065\u2c2b")) + System.getProperty(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u08cc\u950e\u3066\u2c6c\u130b\u56c6\u1ead\u7c1d\ue914"))).hashCode());
            }
            jnatmp.mkdirs();
            if (!jnatmp.exists() || !jnatmp.canWrite()) {
                jnatmp = tmp;
            }
        }
        if (!jnatmp.exists()) {
            throw new IOException(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u0898\u9547\u3029\u2c4a\u133a\u56b9\u1eca\u7c74\ue975\u55d6\u0d12\ua27b\ua96e\ua342\u7099\ud12f\ub80d\u1dd5\u7738\uf650\u4524\ucb54\uca00\u65bf\u493e")) + jnatmp + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u08ed\u952e\u3014\u2c02\u1333\u56a8\u1e9f\u7c6d\ue96d\u55d7\u0d4b\ua26b\ua977\ua30c\u7096\ud135")));
        }
        if (!jnatmp.canWrite()) {
            throw new IOException(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u0898\u9547\u3029\u2c4a\u133a\u56b9\u1eca\u7c74\ue975\u55d6\u0d12\ua27b\ua96e\ua342\u7099\ud12f\ub80d\u1dd5\u7738\uf650\u4524\ucb54\uca00\u65bf\u493e")) + jnatmp + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u089e\u955d\u306a\u2c6d\u1305\u56c6\u1ea3\u7c04\ue951\u55a7\u0d6a\ua214\ua908\ua377\u70f4\ud15e\ub871")));
        }
        return jnatmp;
    }

    static void markTemporaryFile(File file) {
        try {
            File marker = new File(file.getParentFile(), file.getName() + ConfigChangedHandler.l(Union$CallbackResultContext.U("\u21e4\u845d")));
            marker.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        return new Pointer(AWT.getWindowID(w));
    }

    private static /* synthetic */ Object lookupField(Class<?> mappingClass, String fieldName, Class<?> resultClass) {
        try {
            Field field = mappingClass.getField(fieldName);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(fieldName + MCDARichHelper.l(Union$CallbackResultContext.U("\u9cb5\u7611\ud115\ube5e\ud689\u6b0e\uf524\u5ebe\u48ed\ue00b\ua76d\u149c\uc452\ud0fc\u8a63\ub33d\ue69d\u84cf\u417f\uf3f5\u92c7\u724b\ucc5a\u2817\u3a61\u2c86\uea9b\u771d\ueb58\u7319\u73d9\u99ff")) + resultClass.getName() + ConfigChangedHandler.l(Union$CallbackResultContext.U("\u9cc1\u763f")) + e + MCDARichHelper.l(Union$CallbackResultContext.U("\u9ccf\u7635\ud133")) + mappingClass);
        }
    }

    @Deprecated
    public static <T> T loadLibrary(String name, Class<T> interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.emptyMap());
    }

    static native float invokeFloat(Function var0, long var1, int var3, Object[] var4);

    public static int getNativeSize(Class<?> cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            if (Structure.ByValue.class.isAssignableFrom(cls)) {
                return Structure.size(cls);
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Platform.HAS_BUFFERS && Buffers.isBuffer(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException(ConfigChangedHandler.l(Union$PointerType.H("\u75be\ua403\u4733\uf2c9\u9e9e\u327f\ub8e7\u6a14\u5085\u7414\uc7e5\u7e72\u017d\uaf7d\u772c\u96c3\u9b4f\u5bfc\u53e9\u02d0\u9964\u12f8")) + cls.getName() + MCDARichHelper.l(Union$PointerType.H("\u75a6\ua429\u475a\uf2b8\u9ebc\u3204\ub8dd\u6a67\u50f6\u746a\uc783\u7e57")));
    }

    public static void register(String libName) {
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), libName);
    }

    private static /* synthetic */ Map<String, Object> cacheOptions(Class<?> cls, Map<String, ?> options, Object proxy) {
        HashMap<String, Object> libOptions = new HashMap<String, Object>(options);
        libOptions.put(StructureWriteContext$MethodResultContext.u("\uf526\u21bf\ubc28\ue0bd\u9767\ufb2d\u8aba\u1088\ub059\uaabc\u686f\uca59\u0624\u4683\u7542\ufc17\u4f2f"), cls);
        typeOptions.put(cls, libOptions);
        if (proxy != null) {
            libraries.put(cls, new WeakReference<Object>(proxy));
        }
        if (!cls.isInterface() && Library.class.isAssignableFrom(cls)) {
            Class<?>[] ifaces;
            for (Class<?> ifc : ifaces = cls.getInterfaces()) {
                if (!Library.class.isAssignableFrom(ifc)) continue;
                Native.cacheOptions(ifc, libOptions, proxy);
                break;
            }
        }
        return libOptions;
    }

    public static long getComponentID(Component c) throws HeadlessException {
        return AWT.getComponentID(c);
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        return new Pointer(AWT.getComponentID(c));
    }

    public static boolean isSupportedNativeType(Class<?> cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean deleteLibrary(File lib) {
        if (lib.delete()) {
            return true;
        }
        Native.markTemporaryFile(lib);
        return false;
    }

    private static /* synthetic */ NativeMapped fromNative(Class<?> cls, Object value) {
        return (NativeMapped)NativeMappedConverter.getInstance(cls).fromNative(value, new FromNativeContext(cls));
    }

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class<?>[] var2, Class<?> var3, int var4, int var5, String var6);

    static native void setFloat(Pointer var0, long var1, long var3, float var5);

    static byte[] getBytes(String s, String encoding) {
        return Native.getBytes(s, Native.getCharset(encoding));
    }

    public static String toString(byte[] buf, Charset charset) {
        int len = buf.length;
        for (int index = 0; index < len; ++index) {
            if (buf[index] != 0) continue;
            len = index;
            break;
        }
        if (len == 0) {
            return "";
        }
        return new String(buf, 0, len, charset);
    }

    static native int initialize_ffi_type(long var0);

    public static File extractFromResourcePath(String name, ClassLoader loader) throws IOException {
        URL url;
        String resourcePath;
        Level DEBUG;
        Level level = DEBUG = DEBUG_LOAD || DEBUG_JNA_LOAD && name.contains(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue21b\u887f\u55b1\u978b\uaefe\ua33e\uff6d\u0185\ue0d2\ubf56\ue5ba"))) ? Level.INFO : Level.FINE;
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = Native.class.getClassLoader();
        }
        LOG.log(DEBUG, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue256\u880a\u55dc\u97f0\uae95\ua357\uff11\u01b0\ue0a4\ubf2f\ue599\ue5cc\u7a99\ua421\u7c7c\ub7cf\uf768\u61f6\uae59\u138a\u707f\ud0b4\u56fb\uad72\ue751\u9ba9\u4416\u26c1\ue8bd\ub124\u5f76\u35c6\u1430\udc94\ue458\u0d17\u8309")), new Object[]{loader, name});
        String libname = name.startsWith(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue25e"))) ? name : NativeLibrary.mapSharedLibraryName(name);
        String string = resourcePath = name.startsWith(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue235"))) ? name : Platform.RESOURCE_PREFIX + ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue25e")) + libname;
        if (resourcePath.startsWith(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue235")))) {
            resourcePath = resourcePath.substring(1);
        }
        if ((url = loader.getResource(resourcePath)) == null) {
            if (resourcePath.startsWith(Platform.RESOURCE_PREFIX)) {
                if (Platform.RESOURCE_PREFIX.startsWith(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue279\u881c\u55c6\u97f4\uae92\ua34f")))) {
                    url = loader.getResource(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue27e\u8804\u55c1\u97ec\uae95\ua357\uff59")) + resourcePath.substring(Platform.RESOURCE_PREFIX.length() + 1));
                }
                if (url == null) {
                    url = loader.getResource(libname);
                }
            } else if (resourcePath.startsWith(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue27e\u8812\u55d9\u97ac\uae88\ua354\uff1f\u01a7\ue0a0\ubf37\ue5df\ue598")) + Platform.RESOURCE_PREFIX + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue235")))) {
                if (Platform.RESOURCE_PREFIX.startsWith(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue27e\u8812\u55d9\u97ac\uae88\ua354\uff1f\u01a7\ue0a0\ubf37\ue5df\ue598\u7a96\ua439\u7c7a\ub7d3\uf776\u61e1")))) {
                    url = loader.getResource(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue20a\u8879\u55ad\u97c7\uaefc\ua33f\uff6b\u01cc\ue0d4\ubf5c\ue5ab\ue5f3\u7ae2\ua452\u7c0e\ub7b8\uf702\u618a")) + resourcePath.substring((ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue27e\u8812\u55d9\u97ac\uae88\ua354\uff1f\u01a7\ue0a0\ubf37\ue5df\ue598")) + Platform.RESOURCE_PREFIX).length() + 1));
                }
                if (url == null) {
                    url = loader.getResource(libname);
                }
            }
        }
        if (url == null) {
            String path = System.getProperty(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue270\u8804\u55c5\u97fa\uaed2\ua35a\uff1a\u01f1\ue0be\ubf32\ue597\ue5df\u7a94\ua434\u7c67")));
            if (loader instanceof URLClassLoader) {
                path = Arrays.asList(((URLClassLoader)loader).getURLs()).toString();
            }
            throw new IOException(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue253\u881c\u55c0\u97ea\uae8d\ua344\uff51\u01e4\ue0a3\ubf3b\ue5cc\ue5d6\u7a80\ua421\u7c28\ub78c")) + resourcePath + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue240\u8836\u55ae\u9787\uaefb\ua36a\uff63\u018c\ue0cb\ubf5c\ue5ae\ue5fc\u7aef\ua45d\u7c5c\ub7bd\uf70e\u6197\uae31\u13e4\u705e\ud0c2\u569f\uad4e\ue73f\u9b9b\u446a\u26ea\ue893\ub15f")) + path + ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue258")));
        }
        LOG.log(DEBUG, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue25c\u880a\u55c6\u97f5\uae98\ua319\uff1a\u01f9\ue0af\ubf33\ue5d8\ue5dd\u7a8c\ua460\u7c7d\ub7d9\uf76b\u61f8\uae58\u1390\u703c\ud0b7\u56a9\uad7c\ue748\u9ba9\u4416\u26c1\ue8bd")), url);
        File lib = null;
        if (url.getProtocol().toLowerCase().equals(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue27b\u8814\u55d8\u97e6")))) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            LOG.log(DEBUG, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue225\u8879\u55af\u9783\uaee6\ua324\uff62\u01c3\ue0d7\ubf5c\ue5ea\ue5a7\u7ab6\ua44e")), lib.getAbsolutePath());
            if (!lib.exists()) {
                throw new IOException(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue237\u8878\u55b4\u978a\uaeb7\ua318\uff4f\u01a8\ue086")) + url + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue249\u8875\u55af\u979d\uaee3\ua32e\uff25\u018d\ue0d1\ubf46\ue5ea\ue5be\u7ae3\ua413\u7c0c\ub7bd\uf704\u6194\uae3b\u13e3\u7040\ud0d8\u56da\uad0a\ue72a\u9b99\u4471\u26e6\ue8d6\ub113")));
            }
        } else if (!Boolean.getBoolean(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue277\u8813\u55d5\u97ad\uae95\ua34e\uff04\u01e6\ue0ba\ubf38\ue5dd\ue5dc")))) {
            InputStream is = url.openStream();
            if (is == null) {
                throw new IOException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue259\u8804\u55dd\u97bc\uae88\ua319\uff19\u01f2\ue0b9\ubf20\ue5d0\ue5c1\u7ad5\ua409\u7c61\ub7cc\uf76d\u61e3\uae7e\u1396\u702d\ud0b7\u56e8\uad70\ue71c\u9bef\u4402\u2683\ue8e0")) + resourcePath);
            }
            FileOutputStream fos = null;
            try {
                int count;
                File dir = Native.getTempDir();
                lib = File.createTempFile(FunctionResultContext$CallbackResultContext.p("\ue219\u8811\u55bb"), Platform.isWindows() ? ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue233\u8819\u55d8\u97ef")) : null, dir);
                if (!Boolean.getBoolean(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue203\u8878\u55a9\u978c\uaee6\ua339\uff75\u0182\ue0ca\ubf51\ue5a2\ue5f2\u7af6\ua441\u7c19\ub7bc\uf70e\u6196\uae28\u13f4")))) {
                    lib.deleteOnExit();
                }
                LOG.log(DEBUG, ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue234\u8869\u55ac\u979d\uaef6\ua32e\uff69\u018d\ue0c8\ubf52\ue5f2\ue5b7\u7af7\ua456\u7c16\ub7a9\uf701\u619a\uae66\u13e2\u705b\ud086\u5699\uad59\ue72a")), lib.getAbsolutePath());
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new IOException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue22f\u8877\u55a9\u9784\uaeea\ua32e\uff25\u0197\ue0d1\ubf12\ue5a9\ue5ae\u7ae3\ua452\u7c08\ub7aa\uf74b\u6190\uae3b\u13fc\u705c\ud0ce\u5688\uad0f\ue73d\u9b83\u443e\u26e4\ue8da\ub11b\u5f06\u35fa\u1457\udca8\ue422\u0d75")) + name + ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\ue23d\u8811\u55dd\u97e1\uae89\ua340\uff03\u01f1\ue0f0\ubf79")) + e.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return lib;
    }

    static native void setPointer(Pointer var0, long var1, long var3, long var5);

    static native float getFloat(Pointer var0, long var1, long var3);

    private static native /* synthetic */ String getAPIChecksum();

    static native void setWideString(Pointer var0, long var1, long var3, String var5);

    static {
        JNA_TMPLIB_PREFIX = Union$PointerType.H("\u2c11\u5c58\u2c7b");
        _OPTION_ENCLOSING_LIBRARY = Union$PointerType.H("\u2c1e\u5c58\u2c79\uf672\u6210\u10f8\u7970\u6010\u2e94\u0a94\uaa68\udb42\uc80c\u5e33\u02e8\u6dfc\u6281");
        LOG = Logger.getLogger(Native.class.getName());
        String nativeEncoding = System.getProperty(MCDARichHelper.l(Union$PointerType.H("\u2c7c\u5c4d\u2c07\uf66d\u6260\u10f4\u795e\u6001\u2ef4\u0ac0\uaa02\udb55\uc86e\u5e35\u0287")));
        Charset nativeCharset = null;
        if (nativeEncoding != null) {
            try {
                nativeCharset = Charset.forName(nativeEncoding);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, ConfigChangedHandler.l(Union$PointerType.H("\u2c3f\u5c39\u2c71\uf61c\u6218\u1081\u793b\u6064\u2e9e\u0af7\uaa61\udb20\uc818\u5e0f\u02e8\u6d88\u629b\u27f6\u8e16\u54ff\u624e\u1f75\u2607\uaba8\u113e\u6d78\uff8a\u7f19\ua919\u2b8e\ue96f\u893c\uf9a1\uc031\u7905\u5c88\u8d81\u0cb2\ucc03\ucac5\u7afd\u2455\ua190\ude91\u763e\u542b\u1f42\uf830\uefb2\ua1f5\u8a6a")) + nativeEncoding + MCDARichHelper.l(Union$PointerType.H("\u2c35")), ex);
            }
        }
        if (nativeCharset == null) {
            nativeCharset = Charset.defaultCharset();
        }
        DEFAULT_CHARSET = nativeCharset;
        DEFAULT_ENCODING = nativeCharset.name();
        DEBUG_LOAD = Boolean.getBoolean(ConfigChangedHandler.l(Union$PointerType.H("\u2c7f\u5c5a\u2c15\uf632\u6275\u10ec\u7915\u6009\u2efa\u0ae4\uaa06\udb46\uc861\u5e27")));
        DEBUG_JNA_LOAD = Boolean.getBoolean(MCDARichHelper.l(Union$PointerType.H("\u2c0b\u5c31\u2c61\uf659\u6201\u1087\u7961\u6062\u2e8e\u0a8f\uaa72\udb2d\uc815\u5e4c\u02bd\u6d8d\u628c\u27e2")));
        DEBUG_JNA_LOAD_LEVEL = DEBUG_JNA_LOAD ? Level.INFO : Level.FINE;
        jnidispatchPath = null;
        typeOptions = Collections.synchronizedMap(new WeakHashMap());
        libraries = Collections.synchronizedMap(new WeakHashMap());
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Callback c, Throwable e) {
                LOG.log(Level.WARNING, FromNativeContext.l(FunctionResultContext$CallbackResultContext.p("\u4e98\u4473\u2141\u288b\u1228\uc827\u347a\u4878\u5f0e\ud109\u7f7b\u305c\u5560\u04aa")) + c + WeakMemoryHolder.l(FunctionResultContext$CallbackResultContext.p("\u4ed5\u4440\u214f\u28ca\u124a\uc81a\u341c\u4869\u5f2d\ud107\u7f1d\u3050\u5543\u04ef\u759d\u2704\u1938\u099f\ua3d8\ufe66\uddf0\u59e7\uc138\ud7a7\u1ed9\uc0db\u7f74\ub0bc\ub5b7\u35ae")), e);
            }
        };
        Native.loadNativeDispatchLibrary();
        if (!Native.isCompatibleVersion(Union$PointerType.H("\u2c4d\u5c18\u2c2b\uf630\u6249"), Native.getNativeVersion())) {
            String LS = System.getProperty(ConfigChangedHandler.l(Union$PointerType.H("\u2c79\u5c5d\u2c1a\uf679\u623f\u10fa\u7912\u600c\u2efc\u0ac9\uaa0b\udb5d\uc86f\u5e31")));
            throw new Error(LS + LS + MCDARichHelper.l(Union$PointerType.H("\u2c35\u5c37\u2c65\uf605\u6200\u10c2\u796a\u6064\u2ec9\u0ab1\uaa70\udb62\uc81d\u5e46\u02f0\u6d88\u628f\u27f3\u8e1c\u54e9\u624b\u1f30\u2615\uaba5\u1174\u6d15\uffb2\u7f3e\ua955\u2b8e\ue960\u892a\uf9fe\uc025\u7916\u5ccc\u8d9a\u0cb8\ucc10\ucade\u7ae3\u2400\ua187\uded7\u7623\u5437\u1f4c\uf863\ueff1\ua1be\u8a39\uac0d\u16fc\u643e\u8406\ub339\uada9\ub3d5\u605f\u651e\u13cd\u9989\u9c7d\ud277\u8c46\u60e1\ua28c\u362b")) + LS + ConfigChangedHandler.l(Union$PointerType.H("\u2c50\u5c4c\u2c04\uf679\u6272\u10fd\u7912\u6018\u2ea7\u0a9b")) + Union$PointerType.H("\u2c4d\u5c18\u2c2b\uf630\u6249") + LS + MCDARichHelper.l(Union$PointerType.H("\u2c27\u5c30\u2c75\uf619\u6201\u10d8\u7923\u6037\u2ec9\u0af0")) + Native.getNativeVersion() + LS + (jnidispatchPath != null ? ConfigChangedHandler.l(Union$PointerType.H("\u2c3d\u5c55\u2c00\uf63c")) + jnidispatchPath + MCDARichHelper.l(Union$PointerType.H("\u2c3b")) : System.getProperty(ConfigChangedHandler.l(Union$PointerType.H("\u2c13\u5c39\u2c6e\uf611\u6253\u1089\u7972\u6072\u2e83\u0ab6\uaa74\udb3c\uc842\u5e5f\u02ea\u6d94\u6292")))) + MCDARichHelper.l(Union$PointerType.H("\u2c3c")) + LS + ConfigChangedHandler.l(Union$PointerType.H("\u2c41\u5c5b\u2c54\uf66e\u6274\u10fa\u7918\u6010\u2eeb\u0ade\uaa4a\udb5d\uc868\u5e2a\u0294\u6dac\u62ff\u279b\u8e7a\u5483\u6233\u1f19\u2674\uabc4\u1155\u6d14\uffe5\u7f75\ua978\u2bab\ue911\u895a\uf9c3\uc057\u7969\u5ce2\u8da2\u0cd5\ucc60\ucae7\u7a82\u2471\ua1ef\udebc\u7658\u545d\u1f27\uf810\uef8b\ua1ce\u8a48\uac6d\u168b\u644f")) + LS + MCDARichHelper.l(Union$PointerType.H("\u2c41\u5c72\u2c20\uf605\u6200\u108f\u796c\u6061\u2e8c\u0af0\uaa71\udb30\uc854\u5e5d\u02fd\u6d8e\u628c\u27f0\u8e09\u54fc\u624e\u1f3e\u2659\uabb4\u113c\u6d3a\uffdc\u7f10\ua913\u2b86\ue964\u8930\uf9f3\uc03a\u791d\u5c8b\u8dd6\u0cbd\ucc1b\ucace\u7af0\u2413\ua18c\ude8e")) + LS + ConfigChangedHandler.l(Union$PointerType.H("\u2c59\u5c75\u2c38\uf603\u6218\u1091\u793b\u6064\u2e99\u0ab2\uaa26\udb36\uc815\u5e5c\u02ff\u6d85\u6297\u27a4\u8e15\u54e8\u6255\u1f25\u2604\uabb5\u1138\u6d21\uffc4\u7f12\ua903\u2b86\ue937\u8937\uf9e0\uc027\u7912\u5c98\u8dd3\u0ca2\ucc18\ucade\u7aff")) + LS + MCDARichHelper.l(Union$PointerType.H("\u2c32\u5c01\u2c53\uf677\u6273\u10e5\u7950\u600e\u2ef4\u0ac2\uaa43\udb53\uc868\u5e34\u0294\u6dba\u62fd\u2799\u8e6c\u549c\u6230\u1f53\u2673\uab9d\u1157\u6d4d\ufffb\u7f64\ua926\u2be7\ue91d\u890d\uf98d\uc04e\u7963\u5cf3\u8df0\u0cc6\ucc64\ucaff\u7a85\u2469\ua1e8\udea4\u7649\u544b\u1f38\uf80c\uefc3\ua1d5\u8a49\uac3b\u169f\u6405\u847f\ub304\uad8c\ub3b7\u6036\u6577\u13a4\u99b5\u9c13\ud25d\u8c29\u6080\ua2ba\u3641\u8fee\u9afc\ud1fb")) + LS + ConfigChangedHandler.l(Union$PointerType.H("\u2c59\u5c78\u2c38\uf61a\u6213\u108c\u797f\u6079\u2e82\u0aa7\uaa67\udb31\uc80f\u5e47\u02ab\u6d8c\u6293\u27e6\u8e17\u54fb\u6248\u1f2c\u2641\uabae\u1122\u6d3b\uff88\u7f0d\ua909\u2b82\ue97d\u8979\uf9f8\uc03d\u791f\u5c83\u8dce\u0ca2\ucc02\ucace\u7aba\u243f\ua1a8\udeb1\u7672\u5434\u1f46\uf862\uefa8\ua1b3\u8a24\uac03\u16e5\u6439\u8408\ub33f\uade4\ub386\u604e\u6502\u13c3\u998e\u9c63\ud27a\u8c44\u60fc\ua296")) + LS);
        }
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        BOOL_SIZE = Native.sizeof(4);
        LONG_DOUBLE_SIZE = Native.sizeof(5);
        Native.initIDs();
        if (Boolean.getBoolean(MCDARichHelper.l(Union$PointerType.H("\u2c78\u5c42\u2c12\uf62a\u6266\u10e3\u791f\u6010\u2eff\u0ac0\uaa19\udb54\uc863")))) {
            Native.setProtected(true);
        }
        MAX_ALIGNMENT = Platform.isSPARC() || Platform.isWindows() || Platform.isLinux() && (Platform.isARM() || Platform.isPPC() || Platform.isMIPS() || Platform.isLoongArch()) || Platform.isAIX() || Platform.isAndroid() && !Platform.isIntel() ? 8 : LONG_SIZE;
        MAX_PADDING = Platform.isMac() && Platform.isPPC() ? 8 : MAX_ALIGNMENT;
        System.setProperty(ConfigChangedHandler.l(Union$PointerType.H("\u2c7f\u5c5a\u2c15\uf632\u627d\u10e6\u7916\u6018\u2ef8\u0adf")), MCDARichHelper.l(Union$PointerType.H("\u2c15\u5c2d\u2c75\uf612")));
        finalizer = new Object(){

            protected void finalize() throws Throwable {
                Native.dispose();
                super.finalize();
            }
        };
        registeredClasses = new WeakHashMap();
        registeredLibraries = new WeakHashMap();
        nativeThreadTerminationFlag = new ThreadLocal<Memory>(){

            @Override
            protected Memory initialValue() {
                Memory m = new Memory(4L);
                m.clear();
                return m;
            }
        };
        nativeThreads = Collections.synchronizedMap(new WeakHashMap());
    }

    public static native long malloc(long var0);

    static native int getInt(Pointer var0, long var1, long var3);

    public static String getDefaultStringEncoding() {
        return System.getProperty(ConfigChangedHandler.l(Union$PointerType.H("\u6092\u61e9\u892a\u31a6\u9087\u32bf\u3a86\u8fbf\u1e2a\ub2f5\u5335\u83a8")), DEFAULT_ENCODING);
    }

    static Class<?> getCallingClass() {
        Class<?>[] context = new SecurityManager(){

            @Override
            public Class<?>[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (context == null) {
            throw new IllegalStateException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u9178\u1f95\u1e4e\u0b1d\ucaa9\u78e1\u8e8a\u15ec\ubfff\ua3c9\u415a\ud754\u09c4\u3dab\u3392\ue062\ud4dc\u2bae\ua7fd\u9dc2\u9b63\u3798\ubae7\u9771\u584f\uec44\u7a85\u98e1\uec8c\ue2cc\uc8b6\ube9b\u2f4b\ubf7c\u7aab\u8f0e\udf2d\ue041\u7df1\u8bb6\u9ce2\ueafa\u22d2\uceee\u90a5\ubcfa\u30bc\u3b32\u6c43\u76ca\ud1f9\ufa26\ud1b2\ud836\udad1\ua96b\ubc73\ue85e\u4c3f\ucd96\u9024\uec6a\u047a\uee1f\u39b8\u853b\u1d09\u87b8\u2505\u41cb\u539c\u79da\uc26c\uc57d\u4a12\u6755\u0d15\uaeef\u81b6\ufdd1\u4926\u0399\u168e\ud86c\uc2cd\u1b1d\u905a\u5c59\u6dbc\u5d05\u1d34\u7957\u3f1e\uda2c\u87df\u1561\uf535\u8956\u80a7\u86ef\u145a\ue8cf\u1c21\u8053\u7c75\uda05\u1e9a\ud07a\ubc34\u75c0\ua526\ubed2")));
        }
        if (context.length < 4) {
            throw new IllegalStateException(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u9160\u1f92\u1e5a\u0b49\ucac2\u78ee\u8e94\u15ea\ubffd\ua3c8\u4152\ud70a\u09fc\u3db8\u3397\ue070\ud483\u2bae\ua7f2\u9dc5\u9b71\u3793\ubae3\u9776\u5857\uec4a\u7ad8\u98ee\uec92\ue2c5\uc8b7\ubed5\u2f48\ubf7d\u7af6\u8f46\udf28\ue012\u7dfc\u8bad\u9cfa\ueaed\u22ca\ucef0\u90bf\ubcf5\u30a4\u3b3a\u6c55\u76d3\ud1e5\ufa7b\ud1a6\ud830\udac9\ua961\ubc7f\ue816\u4c2d\ucdd4\u9031\uec3a\u0423\uee12\u39bc")));
        }
        return context[3];
    }

    public static List<String> toStringList(char[] buf) {
        return Native.toStringList(buf, 0, buf.length);
    }

    static Pointer getPointer(long addr) {
        long peer = Native._getPointer(addr);
        return peer == 0L ? null : new Pointer(peer);
    }

    static native long getLong(Pointer var0, long var1, long var3);

    static native void read(Pointer var0, long var1, long var3, char[] var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Class<?> cls) {
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            long[] handles = registeredClasses.get(cls);
            if (handles != null) {
                Native.unregister(cls, handles);
                registeredClasses.remove(cls);
                registeredLibraries.remove(cls);
            }
        }
    }

    public static List<String> toStringList(char[] buf, int offset, int len) {
        ArrayList<String> list = new ArrayList<String>();
        int lastPos = offset;
        int maxPos = offset + len;
        for (int curPos = offset; curPos < maxPos; ++curPos) {
            if (buf[curPos] != '\u0000') continue;
            if (lastPos == curPos) {
                return list;
            }
            String value = new String(buf, lastPos, curPos - lastPos);
            list.add(value);
            lastPos = curPos + 1;
        }
        if (lastPos < maxPos) {
            String value = new String(buf, lastPos, maxPos - lastPos);
            list.add(value);
        }
        return list;
    }

    public static byte[] toByteArray(String s, String encoding) {
        return Native.toByteArray(s, Native.getCharset(encoding));
    }

    public static void setCallbackThreadInitializer(Callback cb, CallbackThreadInitializer initializer) {
        CallbackReference.setCallbackThreadInitializer(cb, initializer);
    }

    public static void unregister() {
        Native.unregister(Native.findDirectMappedClass(Native.getCallingClass()));
    }

    static native void setByte(Pointer var0, long var1, long var3, byte var5);

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler eh) {
        callbackExceptionHandler = eh == null ? DEFAULT_HANDLER : eh;
    }

    static native long invokePointer(Function var0, long var1, int var3, Object[] var4);

    static native double invokeDouble(Function var0, long var1, int var3, Object[] var4);

    private static /* synthetic */ int getConversion(Class<?> type, TypeMapper mapper, boolean allowObjects) {
        if (type == Void.class) {
            type = Void.TYPE;
        }
        if (mapper != null) {
            FromNativeConverter fromNative = mapper.getFromNativeConverter(type);
            ToNativeConverter toNative = mapper.getToNativeConverter(type);
            if (fromNative != null) {
                Class<?> nativeType = fromNative.nativeType();
                if (nativeType == String.class) {
                    return 24;
                }
                if (nativeType == WString.class) {
                    return 25;
                }
                return 23;
            }
            if (toNative != null) {
                Class<?> nativeType = toNative.nativeType();
                if (nativeType == String.class) {
                    return 24;
                }
                if (nativeType == WString.class) {
                    return 25;
                }
                return 23;
            }
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return 1;
        }
        if (String.class == type) {
            return 2;
        }
        if (WString.class.isAssignableFrom(type)) {
            return 20;
        }
        if (Platform.HAS_BUFFERS && Buffers.isBuffer(type)) {
            return 5;
        }
        if (Structure.class.isAssignableFrom(type)) {
            if (Structure.ByValue.class.isAssignableFrom(type)) {
                return 4;
            }
            return 3;
        }
        if (type.isArray()) {
            switch (type.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (type.isPrimitive()) {
            return type == Boolean.TYPE ? 14 : 0;
        }
        if (Callback.class.isAssignableFrom(type)) {
            return 15;
        }
        if (IntegerType.class.isAssignableFrom(type)) {
            return 21;
        }
        if (PointerType.class.isAssignableFrom(type)) {
            return 22;
        }
        if (NativeMapped.class.isAssignableFrom(type)) {
            Class<?> nativeType = NativeMappedConverter.getInstance(type).nativeType();
            if (nativeType == String.class) {
                return 18;
            }
            if (nativeType == WString.class) {
                return 19;
            }
            return 17;
        }
        if (JNIEnv.class == type) {
            return 27;
        }
        return allowObjects ? 26 : -1;
    }

    public static Map<String, Object> getLibraryOptions(Class<?> type) {
        Map<String, Object> libraryOptions = typeOptions.get(type);
        if (libraryOptions != null) {
            return libraryOptions;
        }
        Class<?> mappingClass = Native.findEnclosingLibraryClass(type);
        if (mappingClass != null) {
            Native.loadLibraryInstance(mappingClass);
        } else {
            mappingClass = type;
        }
        libraryOptions = typeOptions.get(mappingClass);
        if (libraryOptions != null) {
            typeOptions.put(type, libraryOptions);
            return libraryOptions;
        }
        try {
            Field field = mappingClass.getField(MCDARichHelper.l(Union$PointerType.H("\u0e63\u38c8\u4eae\ue4e1\u521c\u5c99\u3e18")));
            field.setAccessible(true);
            libraryOptions = (Map<String, Object>)field.get(null);
            if (libraryOptions == null) {
                throw new IllegalStateException(ConfigChangedHandler.l(Union$PointerType.H("\u0e65\u38f5\u4e91\ue4dc\u5274\u5ca0\u3e3c\u19f6\uc0ef\u1704\ue1fe\u452a\u49d7\u6b21\u0a3d\u6f7e\ub21e\uc7d8")));
            }
        }
        catch (NoSuchFieldException e) {
            libraryOptions = Collections.emptyMap();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MCDARichHelper.l(Union$PointerType.H("\u0e10\u38bb\u4edd\ue492\u526f\u5cea\u3e6b\u19c9\uc09f\u1775\ue197\u4546\u49a3\u6b4e\u0a45\u6f50\ub267\uc7f7\uc936\ua2cf\u3343\u74da\u0a23\uc624\u7b1f\u35e4\u80b5\udaf6\uacce\u83ff\u1546\u53a1\u3600\u8917\u1bba\u19a6\u0002\u6793\u4045\u087f\u31fb\u887d\ua0ea\u14c3\u83fd\u1c32\u4bd8\ubd16\u4911\uae07\u5712\u946d\ud360\uebbd")) + e + ConfigChangedHandler.l(Union$PointerType.H("\u0e6e\u38d6\u4eb1")) + mappingClass);
        }
        libraryOptions = new HashMap<String, Object>(libraryOptions);
        if (!libraryOptions.containsKey(Union$PointerType.H("\u0e31\u38fb\u4ee3\ue4d7\u5217\u5ca0\u3e43\u19f0\uc098\u170c\ue18c"))) {
            libraryOptions.put(Union$PointerType.H("\u0e31\u38fb\u4ee3\ue4d7\u5217\u5ca0\u3e43\u19f0\uc098\u170c\ue18c"), Native.lookupField(mappingClass, MCDARichHelper.l(Union$PointerType.H("\u0e78\u38c1\u4eaa\ue4ed\u520c\u5c9a\u3e0a\u19ca\uc0d1\u1736\ue1c5")), TypeMapper.class));
        }
        if (!libraryOptions.containsKey(Union$PointerType.H("\u0e36\u38f6\u4ee1\ue4c7\u5259\u5cb9\u3e57\u19f2\uc08d\u1744\ue19f\u4537\u49f0\u6b22\u0a54\u6f74\ub279\uc7d0\uc928"))) {
            libraryOptions.put(Union$PointerType.H("\u0e36\u38f6\u4ee1\ue4c7\u5259\u5cb9\u3e57\u19f2\uc08d\u1744\ue19f\u4537\u49f0\u6b22\u0a54\u6f74\ub279\uc7d0\uc928"), Native.lookupField(mappingClass, ConfigChangedHandler.l(Union$PointerType.H("\u0e14\u38b8\u4ec3\ue489\u527b\u5cf7\u3e75\u19bc\uc0af\u1758\ue1bd\u4579\u49d2\u6b6c\u0a76\u6f3a\ub25b\uc79e\uc90a")), Integer.class));
        }
        if (!libraryOptions.containsKey(Union$PointerType.H("\u0e36\u38f6\u4ee1\ue4db\u5254\u5caa\u3e0f\u19e5\uc086\u170a\ue191\u453f\u49f0\u6b2b\u0a5d"))) {
            libraryOptions.put(Union$PointerType.H("\u0e36\u38f6\u4ee1\ue4db\u5254\u5caa\u3e0f\u19e5\uc086\u170a\ue191\u453f\u49f0\u6b2b\u0a5d"), Native.lookupField(mappingClass, MCDARichHelper.l(Union$PointerType.H("\u0e7f\u38cc\u4ea8\ue4e1\u521d\u5c90\u3e14\u19df\uc0cf\u1730\ue1d8\u4505\u49b9\u6b11\u0a14")), String.class));
        }
        libraryOptions = Native.cacheOptions(mappingClass, libraryOptions, null);
        if (type != mappingClass) {
            typeOptions.put(type, libraryOptions);
        }
        return libraryOptions;
    }

    static native void write(Pointer var0, long var1, long var3, double[] var5, int var6, int var7);

    public static <T extends Library> T load(Class<T> interfaceClass, Map<String, ?> options) {
        return Native.load(null, interfaceClass, options);
    }

    static native void setInt(Pointer var0, long var1, long var3, int var5);

    static native long open(String var0, int var1);

    private static /* synthetic */ Charset getCharset(String encoding) {
        Charset charset = null;
        if (encoding != null) {
            try {
                charset = Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                LOG.log(Level.WARNING, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u16b6\u3593\u701f\ud73d\u9fb9\uccda\u58db\u877c\u957f\u90f6\u8bfd\u59df\u9289\u6edf\ucf39\uc95c\uea89\ua229\uc191\uc42a\u70d1\ue879\u2257\u5452\uecd4\u6998\u714a\ua900\u28a8\u6925\u58df\u5d09\u8132\uf03e\uefb8\ue502\u1d48\uc013\u1720\u73a5\ud611\u1832\ue5b2\u9849\u9f61\u2f98\u8ff8\u5cdd\u18c2\uc44d")), new Object[]{encoding, e.getMessage()});
            }
            catch (UnsupportedCharsetException e) {
                LOG.log(Level.WARNING, MCDARichHelper.l(Union$CallbackResultContext.U("\u16c2\u35f8\u706b\ud756\u9fcd\uccb1\u58af\u8717\u950b\u909d\u8b89\u59b4\u92fd\u6eb4\ucf4d\uc937\ueafd\ua242\uc1e5\uc441\u70a5\ue812\u2223\u5439\ueca0\u69f3\u713e\ua96b\u28dc\u694e\u58ab\u5d62\u8146\uf055\uefcc\ue569\u1d3c\uc078\u1754\u73ce\ud665\u1859\ue5c6\u9822\u9f15\u2ff3\u8f8c\u5cb6\u18b6\uc426")), new Object[]{encoding, e.getMessage()});
            }
        }
        if (charset == null) {
            LOG.log(Level.WARNING, ConfigChangedHandler.l(Union$CallbackResultContext.U("\u16b6\u3593\u701f\ud73d\u9fb9\uccda\u58db\u877c\u957f\u90f6\u8bfd\u59df\u9289\u6ecf\ucf24\uc956\uea88\ua22a\uc1d8\uc422\u70d7\ue835\u221c\u5417\uecce\u69cb\u715c\ua907\u28ea\u696b\u58d5\u5d15\u8176\uf022\uefb8\ue516\u1d1d\uc018\u1760\u73b7")), DEFAULT_CHARSET);
            charset = DEFAULT_CHARSET;
        }
        return charset;
    }

    static native void write(Pointer var0, long var1, long var3, float[] var5, int var6, int var7);

    static String replace(String s1, String s2, String str) {
        StringBuilder buf = new StringBuilder();
        while (true) {
            int idx;
            if ((idx = str.indexOf(s1)) == -1) break;
            buf.append(str.substring(0, idx));
            buf.append(s2);
            str = str.substring(idx + s1.length());
        }
        buf.append(str);
        return buf.toString();
    }

    static String getString(Pointer pointer, long offset, String encoding) {
        byte[] data = Native.getStringBytes(pointer, pointer.peer, offset);
        if (encoding != null) {
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(data);
    }

    public static String toString(byte[] buf, String encoding) {
        return Native.toString(buf, Native.getCharset(encoding));
    }

    static native void write(Pointer var0, long var1, long var3, int[] var5, int var6, int var7);

    static native int invokeInt(Function var0, long var1, int var3, Object[] var4);

    private static native /* synthetic */ void unregister(Class<?> var0, long[] var1);

    static native byte getByte(Pointer var0, long var1, long var3);

    public static int getNativeSize(Class<?> type, Object value) {
        if (type.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type.getComponentType(), o);
            }
            throw new IllegalArgumentException(MCDARichHelper.l(Union$CallbackResultContext.U("\u8db4\u1d3c\u96e6\ua951\udce3\u6ff8\uabab\u6c73\u9b15\ubc9f\u86ae\u6c87\u5c4b\uc673\u38c2\ue10a\u731d\u1f9a\ub590\u6477\u5c01\u3212\u5b20\u4a69\ue857\u0930\u30a5\u0f2d\u8823\u227a\u8b0e\u53e5\u95d3\u4c3d\u0ac6")) + type);
        }
        if (Structure.class.isAssignableFrom(type) && !Structure.ByReference.class.isAssignableFrom(type)) {
            return Structure.size(type, (Structure)value);
        }
        try {
            return Native.getNativeSize(type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u8da6\u1d3e\u96f6\ua908\udce9\u6fea\uabfc\u6c61\u9b54\ubc85")) + type.getName() + MCDARichHelper.l(Union$CallbackResultContext.U("\u8da4\u1d1d\u968e\ua930\udcc9\u6f96\uab97\u6c1b\u9b20\ubcbf\u86c4\u6ce1\u5c26\uc608\u38b7\ue165\u732b\u1ff7\ub5bc\u6456")) + e.getMessage());
        }
    }

    public static synchronized native void setProtected(boolean var0);

    static String getSignature(Class<?> cls) {
        if (cls.isArray()) {
            return ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub315")) + Native.getSignature(cls.getComponentType());
        }
        if (cls.isPrimitive()) {
            if (cls == Void.TYPE) {
                return MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub373"));
            }
            if (cls == Boolean.TYPE) {
                return ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub314"));
            }
            if (cls == Byte.TYPE) {
                return MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub367"));
            }
            if (cls == Short.TYPE) {
                return ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub31d"));
            }
            if (cls == Character.TYPE) {
                return MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub366"));
            }
            if (cls == Integer.TYPE) {
                return ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub307"));
            }
            if (cls == Long.TYPE) {
                return MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub36f"));
            }
            if (cls == Float.TYPE) {
                return ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub308"));
            }
            if (cls == Double.TYPE) {
                return MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub361"));
            }
        }
        return ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub302")) + Native.replace(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub30b")), ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\ub361")), cls.getName()) + MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\ub31e"));
    }

    private static /* synthetic */ NativeMapped fromNative(Method m, Object value) {
        Class<?> cls = m.getReturnType();
        return (NativeMapped)NativeMappedConverter.getInstance(cls).fromNative(value, new MethodResultContext(cls, null, null, m));
    }

    static String getString(Pointer pointer, long offset) {
        return Native.getString(pointer, offset, Native.getDefaultStringEncoding());
    }

    static native void setDouble(Pointer var0, long var1, long var3, double var5);

    public static String toString(byte[] buf) {
        return Native.toString(buf, Native.getDefaultStringEncoding());
    }

    static native short getShort(Pointer var0, long var1, long var3);

    static byte[] getBytes(String s, Charset charset) {
        return s.getBytes(charset);
    }

    private static /* synthetic */ Object toNative(ToNativeConverter cvt, Object o) {
        return cvt.toNative(o, new ToNativeContext());
    }

    public static void detach(boolean detach) {
        Thread thread = Thread.currentThread();
        if (detach) {
            nativeThreads.remove(thread);
            Pointer p = nativeThreadTerminationFlag.get();
            Native.setDetachState(true, 0L);
        } else if (!nativeThreads.containsKey(thread)) {
            Pointer p = nativeThreadTerminationFlag.get();
            nativeThreads.put(thread, p);
            Native.setDetachState(false, p.peer);
        }
    }

    public static String getStringEncoding(Class<?> cls) {
        Map<String, Object> options = Native.getLibraryOptions(cls);
        String encoding = (String)options.get(Union$CallbackResultContext.U("\u0175\u1ba5\ucbc2\u72da\ubcc8\u5a93\u3f35\ud26e\u8080\u436a\u38a7\u960c\u31d2\u0789\uc6d8"));
        return encoding != null ? encoding : Native.getDefaultStringEncoding();
    }

    private static /* synthetic */ Object fromNative(FromNativeConverter cvt, Object o, Method m) {
        return cvt.fromNative(o, new MethodResultContext(m.getReturnType(), null, null, m));
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty(ConfigChangedHandler.l(Union$CallbackResultContext.U("\udc9a\uf626\u29af\u144c\ud571\u38ef\u0691\ua5ea\uee97\u8be6\u3ca2\u9fee\u1aa7\u9bf2\uc01f\uc211\ub1d6\ube93\u7bea\u1ea9"))) == null) {
            return null;
        }
        try {
            ClassLoader cl = Native.class.getClassLoader();
            Method m = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method m = ClassLoader.class.getDeclaredMethod(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u518f\uf205\u0d0f\u4b0c\u5006\u8c5f\u833e\u8aa4\u1331\u2d83\ude9b")), String.class);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static native /* synthetic */ long _getPointer(long var0);

    static native void close(long var0);

    static native void write(Pointer var0, long var1, long var3, byte[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, short[] var5, int var6, int var7);

    public static <T extends Library> T load(String name, Class<T> interfaceClass) {
        return Native.load(name, interfaceClass, Collections.emptyMap());
    }

    public static void register(Class<?> cls, String libName) {
        NativeLibrary library = NativeLibrary.getInstance(libName, Collections.singletonMap(Union$CallbackResultContext.U("\u71d5\uad5e\u78ec\u5b17\uc9d8\u315f\ub009\uc661\uf960\uc9e7\ud4ae"), cls.getClassLoader()));
        Native.register(cls, library);
    }

    static Pointer getTerminationFlag(Thread t) {
        return nativeThreads.get(t);
    }

    public static TypeMapper getTypeMapper(Class<?> cls) {
        Map<String, Object> options = Native.getLibraryOptions(cls);
        return (TypeMapper)options.get(FunctionResultContext$CallbackResultContext.p("\u3911\u7a2f\u4150\uc52a\u9ff5\u831c\u1870\u7972\uf691\u1a15\u9dd3"));
    }

    static native void read(Pointer var0, long var1, long var3, long[] var5, int var6, int var7);

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u9df4\u8668\ubb61\u1e67\uc7a6\ucff6\u2c54\u2998\u22c6\u94b2\u5597\u86f8\u1640\u589d\uba4e\u9322\ub32f\ub507\u2995\ud6ed\udb34\u5423\ua857\u126d\u68a7\ue08d\u43b2\u4d0a\u6e88")));
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u9dea\u8677\ubb76\u1e68\uc7a3\ucff3\u2c4d\u29ce\u22c5\u94a5\u5586\u86f0\u1647\u5897\uba5e\u9375\ub331\ub546\u29c2\ud6ef\udb3d\u542d\ua84d\u1239\u68a6\ue08b\u43ee\u4d41")) + ih);
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, args);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    public static char[] toCharArray(String s) {
        char[] chars = s.toCharArray();
        char[] buf = new char[chars.length + 1];
        System.arraycopy(chars, 0, buf, 0, chars.length);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Class<?> cls, NativeLibrary lib) {
        Method[] methods = cls.getDeclaredMethods();
        ArrayList<Method> mlist = new ArrayList<Method>();
        Map<String, Object> options = lib.getOptions();
        TypeMapper mapper = (TypeMapper)options.get(Klass$JNIEnv.n("\ua95c\ubd44\u8d92\u3e9b\u990f\uad28\uddb2\u22df\uef1f\ufe81\u5d63"));
        boolean allowObjects = Boolean.TRUE.equals(options.get(Klass$JNIEnv.n("\ua949\ubd51\u8d8e\u3e91\u9955\uad68\uddbc\u22cd\uef05\ufe81\u5d72\u7d9d\ud928")));
        options = Native.cacheOptions(cls, options, null);
        for (Method m : methods) {
            if ((m.getModifiers() & 0x100) == 0) continue;
            mlist.add(m);
        }
        long[] handles = new long[mlist.size()];
        for (int i = 0; i < handles.length; ++i) {
            long rtype;
            long closure_rtype;
            Method method = (Method)mlist.get(i);
            String sig = MCDARichHelper.l(Klass$JNIEnv.n("\ua969"));
            Class<?> rclass = method.getReturnType();
            Class<?>[] ptypes = method.getParameterTypes();
            long[] atypes = new long[ptypes.length];
            long[] closure_atypes = new long[ptypes.length];
            int[] cvt = new int[ptypes.length];
            ToNativeConverter[] toNative = new ToNativeConverter[ptypes.length];
            FromNativeConverter fromNative = null;
            int rcvt = Native.getConversion(rclass, mapper, allowObjects);
            boolean throwLastError = false;
            switch (rcvt) {
                case -1: {
                    throw new IllegalArgumentException(rclass + ConfigChangedHandler.l(Klass$JNIEnv.n("\ua90a\ubd3a\u8d93\u3eb0\u994e\uad44\udda5\u22e1\uef0c\ufeaa\u5d60\u7df2\ud929\u8cb2\ud871\ub9cc\u17d6\uff7e\u92c1\uf3da\u49c7\u2ab8\u9141\ufd06\ua302\ueb10\u7197\u9dcb\uaa5d\u3d6b\ue488\ud2f7\u1554\u71da\ufa90\u9b13\u7688\u210f\u75b8\u66cd\u549d\u80e3\u900d")) + method.getName() + MCDARichHelper.l(Klass$JNIEnv.n("\ua912\ubd3d\u8d96\u3eb7")) + cls + ConfigChangedHandler.l(Klass$JNIEnv.n("\ua903")));
                }
                case 23: 
                case 24: 
                case 25: {
                    fromNative = mapper.getFromNativeConverter(rclass);
                    closure_rtype = Structure.FFIType.get(rclass.isPrimitive() ? rclass : Pointer.class).getPointer().peer;
                    rtype = Structure.FFIType.get(fromNative.nativeType()).getPointer().peer;
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    closure_rtype = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    rtype = Structure.FFIType.get(NativeMappedConverter.getInstance(rclass).nativeType()).getPointer().peer;
                    break;
                }
                case 3: 
                case 26: {
                    closure_rtype = rtype = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    break;
                }
                case 4: {
                    closure_rtype = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    rtype = Structure.FFIType.get(rclass).getPointer().peer;
                    break;
                }
                default: {
                    closure_rtype = rtype = Structure.FFIType.get(rclass).getPointer().peer;
                }
            }
            block19: for (int t = 0; t < ptypes.length; ++t) {
                int conversionType;
                Class<?> type = ptypes[t];
                sig = sig + Native.getSignature(type);
                cvt[t] = conversionType = Native.getConversion(type, mapper, allowObjects);
                if (conversionType == -1) {
                    throw new IllegalArgumentException(type + MCDARichHelper.l(Klass$JNIEnv.n("\ua961\ubd4e\u8df8\u3ec4\u9925\uad30\uddce\u2295\uef67\ufede\u5d0b\u7d86\ud942\u8cc6\ud81a\ub9b8\u17bd\uff0a\u92aa\uf3ae\u49bf\u2adb\u9139\ufd72\ua376\ueb6f\u71b2\u9dbf\uaa6f\u3d1b\ue4ff\ud2d3\u1572\u71e7\ufabd\u9b2e\u76e0\u213e\u75ca\u66b4\u54ed\u809b\u9029\u3507\uff8c")) + method.getName() + ConfigChangedHandler.l(Klass$JNIEnv.n("\ua966\ubd56\u8de2\u3edc")) + cls + MCDARichHelper.l(Klass$JNIEnv.n("\ua968")));
                }
                if (conversionType == 17 || conversionType == 18 || conversionType == 19 || conversionType == 21) {
                    type = NativeMappedConverter.getInstance(type).nativeType();
                } else if (conversionType == 23 || conversionType == 24 || conversionType == 25) {
                    toNative[t] = mapper.getToNativeConverter(type);
                }
                switch (conversionType) {
                    case 4: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: {
                        atypes[t] = Structure.FFIType.get(type).getPointer().peer;
                        closure_atypes[t] = Structure.FFIType.get(Pointer.class).getPointer().peer;
                        continue block19;
                    }
                    case 23: 
                    case 24: 
                    case 25: {
                        closure_atypes[t] = Structure.FFIType.get(type.isPrimitive() ? type : Pointer.class).getPointer().peer;
                        atypes[t] = Structure.FFIType.get(toNative[t].nativeType()).getPointer().peer;
                        continue block19;
                    }
                    case 0: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get(type).getPointer().peer;
                        continue block19;
                    }
                    default: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    }
                }
            }
            sig = sig + ConfigChangedHandler.l(Klass$JNIEnv.n("\ua903"));
            sig = sig + Native.getSignature(rclass);
            Class<?>[] etypes = method.getExceptionTypes();
            for (int e = 0; e < etypes.length; ++e) {
                if (!LastErrorException.class.isAssignableFrom(etypes[e])) continue;
                throwLastError = true;
                break;
            }
            Function f = lib.getFunction(method.getName(), method);
            try {
                handles[i] = Native.registerMethod(cls, method.getName(), sig, cvt, closure_atypes, atypes, rcvt, closure_rtype, rtype, method, f.peer, f.getCallingConvention(), throwLastError, toNative, fromNative, f.encoding);
                continue;
            }
            catch (NoSuchMethodError e) {
                throw new UnsatisfiedLinkError(MCDARichHelper.l(Klass$JNIEnv.n("\ua97c\ubd3b\u8dd8\u3efa\u995d\uad58\udda1\u22a9\uef11\ufead")) + method.getName() + ConfigChangedHandler.l(Klass$JNIEnv.n("\ua966\ubd48\u8de5\u3e88\u9924\uad67\uddce\u22c4\uef66\ufe88\u5d1e\u7d9f\ud940\u8cdc\ud817\ub9f2")) + sig + MCDARichHelper.l(Klass$JNIEnv.n("\ua912\ubd3d\u8d96\u3eb7")) + cls);
            }
        }
        Map<Class<?>, long[]> i = registeredClasses;
        synchronized (i) {
            registeredClasses.put(cls, handles);
            registeredLibraries.put(cls, lib);
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return;
        }
    }

    static native void setLong(Pointer var0, long var1, long var3, long var5);

    static native long getWindowHandle0(Component var0);

    static native void setMemory(Pointer var0, long var1, long var3, long var5, byte var7);

    static synchronized native void freeNativeCallback(long var0);

    public static <T extends Library> T load(Class<T> interfaceClass) {
        return Native.load(null, interfaceClass);
    }

    public static synchronized native boolean isProtected();

    static native void read(Pointer var0, long var1, long var3, byte[] var5, int var6, int var7);

    static native byte[] getStringBytes(Pointer var0, long var1, long var3);

    private static /* synthetic */ void dispose() {
        CallbackReference.disposeAll();
        Memory.disposeAll();
        NativeLibrary.disposeAll();
        Native.unregisterAll();
        jnidispatchPath = null;
        System.setProperty(ConfigChangedHandler.l(Union$PointerType.H("\u2f3d\ud5a1\u3218\uc285\ufcb3\ub3da\u052b\u15a5\u0c85\uf6df")), MCDARichHelper.l(Union$PointerType.H("\u2f36\ud5b6\u3212\uc2c0\ufcbd")));
    }

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    private static native /* synthetic */ String getNativeVersion();

    static native void invokeVoid(Function var0, long var1, int var3, Object[] var4);

    static native void setChar(Pointer var0, long var1, long var3, char var5);

    private static native /* synthetic */ void initIDs();

    @Deprecated
    public static <T> T loadLibrary(String name, Class<T> interfaceClass, Map<String, ?> options) {
        if (!Library.class.isAssignableFrom(interfaceClass)) {
            throw new IllegalArgumentException(ConfigChangedHandler.l(Union$PointerType.H("\u0bcd\u45e3\u35f1\u2b4d\u4df6\u3994\u4faf\ub3d5\ucaac\u4118\u0508")) + interfaceClass.getSimpleName() + MCDARichHelper.l(Union$PointerType.H("\u0bc6\u45d9\u3581\u2b3a\u4dcf\u39ea\u4fcc\ub3a0\ucad0\u412d\u0539\u5a2f\u58f4")) + name + ConfigChangedHandler.l(Union$PointerType.H("\u0ba4\u45e9\u35ea\u2b4d\u4df7\u39d2\u4fa0\ub3d9\ucabd\u4118\u0545\u5a5a\u58d6\ub3c5\u14d7\u7784\ue284")) + Library.class.getSimpleName());
        }
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Object proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Native.cacheOptions(interfaceClass, options, proxy);
        return interfaceClass.cast(proxy);
    }

    public static void main(String[] args) {
        String version;
        String title;
        String DEFAULT_TITLE = MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u7b96\u7910\u972e\ub355\ub03c\u9f5b\u8492\u3d2c\uc92b\u3605\u7f58\uffe0\u09e0\u6bfa\u7dee\u3b13\uc55d\u143c\ueb4e\ua269\u41eb\u4682\uac5b\u2347"));
        String DEFAULT_VERSION = FunctionResultContext$CallbackResultContext.p("\u7bf3\u7936\u9773\ub36e\ub028\u9f4c");
        String DEFAULT_BUILD = ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u7b9d\u7934\u971d\ub36c\ub046\u9f4e\u84a7\u3d1b\uc946\u3679\u7f2a\uffc0\u09b4\u6b95\u7d9c\u3b3d\uc533\u144a\ueb7c\ua245\u41a7\u46ca\uac0f\u2371\u146a\ua7aa\uebee\u2479\ua429\u669c\ud6a9\uec17\u4660\u08ea\uea1d\u3da2"));
        Package pkg = Native.class.getPackage();
        String string = title = pkg != null ? pkg.getSpecificationTitle() : MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u7b96\u7910\u972e\ub355\ub03c\u9f5b\u8492\u3d2c\uc92b\u3605\u7f58\uffe0\u09e0\u6bfa\u7dee\u3b13\uc55d\u143c\ueb4e\ua269\u41eb\u4682\uac5b\u2347"));
        if (title == null) {
            title = ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u7be2\u797b\u975a\ub33e\ub048\u9f30\u84e6\u3d47\uc95f\u366e\u7f2c\uff8b\u0994\u6b91\u7d9a\u3b78\uc529\u1457\ueb3a\ua202\u419f\u46e9\uac2f\u232c"));
        }
        String string2 = version = pkg != null ? pkg.getSpecificationVersion() : FunctionResultContext$CallbackResultContext.p("\u7bf3\u7936\u9773\ub36e\ub028\u9f4c");
        if (version == null) {
            version = FunctionResultContext$CallbackResultContext.p("\u7bf3\u7936\u9773\ub36e\ub028\u9f4c");
        }
        title = title + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u7b8f\u7943\u977b\ub30e\ub04f\u9f30\u84e5\u3d59\uc942\u3669\u7f21\uffdd\u09f2")) + version;
        System.out.println(title);
        String string3 = version = pkg != null ? pkg.getImplementationVersion() : ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u7b9d\u7934\u971d\ub36c\ub046\u9f4e\u84a7\u3d1b\uc946\u3679\u7f2a\uffc0\u09b4\u6b95\u7d9c\u3b3d\uc533\u144a\ueb7c\ua245\u41a7\u46ca\uac0f\u2371\u146a\ua7aa\uebee\u2479\ua429\u669c\ud6a9\uec17\u4660\u08ea\uea1d\u3da2"));
        if (version == null) {
            version = MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u7be9\u795f\u9769\ub307\ub032\u9f25\u84d3\u3d70\uc932\u3612\u7f5e\uffab\u09c0\u6bfe\u7de8\u3b56\uc547\u1421\ueb08\ua22e\u41d3\u46a1\uac7b\u231a\u141e\ua7c1\ueb9a\u2412\ua45d\u66f7\ud6dd\uec7c\u4614\u0881\uea69\u3dc9"));
        }
        System.out.println(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u7b92\u7913\u9732\ub340\ub06d\u9f7d\u8485\u3d65\uc97a")) + version);
        System.out.println(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u7b8f\u794c\u974a\ub333\ub006\u9f10\u84e5\u3d11\uc911")) + Native.getNativeVersion() + ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u7b88\u7932")) + Native.getAPIChecksum() + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u7b86")));
        System.out.println(ConfigChangedHandler.l(FunctionResultContext$CallbackResultContext.p("\u7be4\u7926\u9732\ub356\ub062\u9f7b\u8493\u3d65\uc97a")) + Platform.RESOURCE_PREFIX);
    }

    private static /* synthetic */ void loadNativeDispatchLibraryFromClasspath() {
        try {
            String libName;
            File lib;
            String mappedName = System.mapLibraryName(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u15fd\ue560\u9a65\u4c26\u9fa8\u6ce6\uad25\ub373\u70df\u8f28\ue6f3"))).replace(ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u15be\ue572\u9a72\u4c36\u9faf\u6cef")), MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u15b9\ue564\u9a62\u4c2b\u9fad\u6cfc\uad37")));
            if (Platform.isAIX()) {
                mappedName = ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u15fc\ue57f\u9a69\u4c30\u9fa8\u6ce4\uad36\ub363\u70df\u8f23\ue6fd\ueb92\u2f7a\u3273\u6cbd\u36e9"));
            }
            if ((lib = Native.extractFromResourcePath(libName = MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u15b8\ue56d\u9a63\u4c2f\u9fee\u6ce6\uad20\ub37c\u7084\u8f21\ue6f5\ueb9f\u2f31")) + Platform.RESOURCE_PREFIX + ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u15d3")) + mappedName, Native.class.getClassLoader())) == null && lib == null) {
                throw new UnsatisfiedLinkError(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u15d4\ue561\u9a79\u4c2e\u9fa5\u6cb5\uad3b\ub37d\u70df\u8f6b\ue6fd\ueb97\u2f70\u3267\u6cb4\u36da\u7c68\u553e\u08c0\u230c\ucc1e\u691e\u4eb3\ud791\u8b3a\u8772\u84e9\u3a14\u6b1d\u7d34\u86be\u8e0d\udf61")));
            }
            LOG.log(DEBUG_JNA_LOAD_LEVEL, ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u15c4\ue564\u9a72\u4c33\u9fa8\u6cea\uad72\ub371\u709c\u8f2e")), lib.getAbsolutePath());
            System.setProperty(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u158e\ue513\u9a16\u4c55\u9fdb\u6c95\uad56\ub300\u70ac\u8f5b\ue680\ueba3\u2f1d\u3211\u6c93\u368b")), lib.getAbsolutePath());
            System.load(lib.getAbsolutePath());
            jnidispatchPath = lib.getAbsolutePath();
            LOG.log(DEBUG_JNA_LOAD_LEVEL, ConfigChangedHandler.l(StructureWriteContext$MethodResultContext.u("\u15d6\ue579\u9a7e\u4c34\u9fa2\u6cad\uad38\ub364\u70c5\u8f37\ue6f5\ueb95\u2f69\u327a\u6ce7\u36eb\u7c49\u5547\u0886\u230e\ucc58\u6909\u4eed\ud782")), jnidispatchPath);
            if (Native.isUnpacked(lib) && !Boolean.getBoolean(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u158e\ue513\u9a16\u4c55\u9fdb\u6c95\uad56\ub300\u70ac\u8f5b\ue680\ueba3\u2f1d\u3202\u6c82\u3690\u7c30\u557e\u08e5\u2374")))) {
                Native.deleteLibrary(lib);
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    public static void register(NativeLibrary lib) {
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), lib);
    }

    public static long getWindowID(Window w) throws HeadlessException {
        return AWT.getWindowID(w);
    }

    static long open(String name) {
        return Native.open(name, -1);
    }

    public static byte[] toByteArray(String s, Charset charset) {
        byte[] bytes = Native.getBytes(s, charset);
        byte[] buf = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public static <T extends Library> T load(String name, Class<T> interfaceClass, Map<String, ?> options) {
        if (!Library.class.isAssignableFrom(interfaceClass)) {
            throw new IllegalArgumentException(ConfigChangedHandler.l(Union$CallbackResultContext.U("\u851f\u8b61\u7b4c\ue2a3\uf931\ub697\u0be4\u3778\ue139\u03aa\u67b9")) + interfaceClass.getSimpleName() + MCDARichHelper.l(Union$CallbackResultContext.U("\u8514\u8b5b\u7b3c\ue2d4\uf908\ub6e9\u0b87\u370d\ue145\u039f\u6788\u4f9d\u61b3")) + name + ConfigChangedHandler.l(Union$CallbackResultContext.U("\u8576\u8b6b\u7b57\ue2a3\uf930\ub6d1\u0beb\u3774\ue128\u03aa\u67f4\u4fe8\u6191\uaa94\u0eaf\ud6ab\u7343")) + Library.class.getSimpleName());
        }
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Object proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Native.cacheOptions(interfaceClass, options, proxy);
        return (T)((Library)interfaceClass.cast(proxy));
    }

    static native void read(Pointer var0, long var1, long var3, int[] var5, int var6, int var7);

    public static String toString(char[] buf) {
        int len = buf.length;
        for (int index = 0; index < len; ++index) {
            if (buf[index] != '\u0000') continue;
            len = index;
            break;
        }
        if (len == 0) {
            return "";
        }
        return new String(buf, 0, len);
    }

    static native double getDouble(Pointer var0, long var1, long var3);

    static native long invokeLong(Function var0, long var1, int var3, Object[] var4);

    private static /* synthetic */ Class<?> nativeType(Class<?> cls) {
        return NativeMappedConverter.getInstance(cls).nativeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registered(Class<?> cls) {
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            return registeredClasses.containsKey(cls);
        }
    }

    static byte[] getBytes(String s) {
        return Native.getBytes(s, Native.getDefaultStringEncoding());
    }

    static native void setShort(Pointer var0, long var1, long var3, short var5);

    private static native /* synthetic */ long registerMethod(Class<?> var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Method var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17, String var18);

    @Deprecated
    public static <T> T loadLibrary(Class<T> interfaceClass, Map<String, ?> options) {
        return Native.loadLibrary(null, interfaceClass, options);
    }

    static native void write(Pointer var0, long var1, long var3, short[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, long[] var5, int var6, int var7);

    static native long findSymbol(long var0, String var2);

    static native Object invokeObject(Function var0, long var1, int var3, Object[] var4);

    public static native void free(long var0);

    static native String getWideString(Pointer var0, long var1, long var3);

    @Deprecated
    public static <T> T loadLibrary(Class<T> interfaceClass) {
        return Native.loadLibrary(null, interfaceClass);
    }

    public static File extractFromResourcePath(String name) throws IOException {
        return Native.extractFromResourcePath(name, null);
    }

    private static class AWT {
        private /* synthetic */ AWT() {
        }

        static long getComponentID(Object o) throws HeadlessException {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException(MCDAClientWindowHelper.l(Klass$JNIEnv.n("\u1a7f\u01c1\u8e42\u2e81\udee0\u3dcf\u1e40\u6773\ue723\u753d\u7740\uedb1\u2f78\uf238\uda49\ub124\ucb49\u202d\u3674\u5d48\u7487\u6211\ud591\u2353\udf32\ud237\u016e\u09ac\u70c8\ua125\ud03e")));
            }
            Component c = (Component)o;
            if (c.isLightweight()) {
                throw new IllegalArgumentException(MCDAEventListener.l(Klass$JNIEnv.n("\u1a6c\u0198\u8e11\u2ec6\udef0\u3d8c\u1e52\u6732\ue72c\u7564\u7744\uedf4\u2f7b\uf271\uda18\ub168\ucb41\u2074\u3675\u5d1c\u749d\u6250\ud5d6\u2315\udf2c\ud266\u0173\u09f1\u70c7")));
            }
            if (!c.isDisplayable()) {
                throw new IllegalStateException(MCDAClientWindowHelper.l(Klass$JNIEnv.n("\u1a72\u01c1\u8e0f\u2e9f\udeee\u3dd5\u1e4c\u676b\ue732\u753d\u775a\uedad\u2f65\uf228\uda06\ub131\ucb5f\u202d\u3667\u5d49\u7491\u620f\ud5dd\u235a\udf2e\ud237\u0168\u09ac\u70c8")));
            }
            if (Platform.isX11() && System.getProperty(MCDAEventListener.l(Klass$JNIEnv.n("\u1a4b\u0198\u8e04\u2ed9\udebf\u3d9a\u1e5c\u6720\ue725\u7523\u7748\uede1"))).startsWith(MCDAClientWindowHelper.l(Klass$JNIEnv.n("\u1a00\u0180\u8e56"))) && !c.isVisible()) {
                throw new IllegalStateException(MCDAEventListener.l(Klass$JNIEnv.n("\u1a6c\u0198\u8e11\u2ec6\udef0\u3d8c\u1e52\u6732\ue72c\u7564\u7744\uedf4\u2f7b\uf271\uda18\ub168\ucb41\u2074\u366b\u5d10\u748f\u624f\ud5cd\u230e\udf2c")));
            }
            return Native.getWindowHandle0(c);
        }

        static long getWindowID(Window w) throws HeadlessException {
            return AWT.getComponentID(w);
        }
    }

    private static class Buffers {
        static boolean isBuffer(Class<?> cls) {
            return Buffer.class.isAssignableFrom(cls);
        }

        private /* synthetic */ Buffers() {
        }
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }
}

